IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME ='EST_PROD_TRANSF_GERAL')
BEGIN

	
	CREATE TABLE [dbo].[EST_PROD_TRANSF_GERAL](
		[CD_CTR] [int] IDENTITY (1,1) NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_FIL_DEST] [int] NOT NULL,
		[DT_TRANSF] [datetime] NULL,
		[DT_ENTR] [datetime] NOT NULL,
		[STS_TRANSF] [int] NOT NULL,
		[DT_CAD] [datetime] NULL,	
	 CONSTRAINT [PK_EST_PROD_TRANSF_GERAL] PRIMARY KEY CLUSTERED 
	(	[CD_CTR] ASC )
		WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 97) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CD_EMP]			DEFAULT ((0)) FOR [CD_EMP]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_CD_FIL_DEST]	DEFAULT ((0)) FOR [CD_FIL_DEST]
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL] ADD  CONSTRAINT [DF_EST_PROD_TRANSF_GERAL_STS_TRANSF]		DEFAULT ((0)) FOR [STS_TRANSF]
	
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TRANSF_GERAL_PRC_FILIAL] FOREIGN KEY([CD_EMP], [CD_FIL_DEST])
				REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP], [CD_FILIAL])
	ALTER TABLE [dbo].[EST_PROD_TRANSF_GERAL]  CHECK CONSTRAINT [FK_EST_PROD_TRANSF_GERAL_PRC_FILIAL]

END 

